/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.inventory;

import io.github.noeppi_noeppi.libx.inventory.IAdvancedItemHandler;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public interface IAdvancedItemHandlerModifiable
extends IItemHandlerModifiable,
IAdvancedItemHandler {
    default public void clear() {
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            this.setStackInSlot(slot, ItemStack.f_41583_);
        }
    }

    default public int clear(Predicate<ItemStack> predicate) {
        int amount = 0;
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            ItemStack stack = this.getStackInSlot(slot);
            if (!predicate.test(stack)) continue;
            amount += stack.m_41613_();
            this.setStackInSlot(slot, ItemStack.f_41583_);
        }
        return amount;
    }

    public static IAdvancedItemHandlerModifiable wrap(final IItemHandlerModifiable handler) {
        if (handler instanceof IAdvancedItemHandlerModifiable) {
            IAdvancedItemHandlerModifiable advanced = (IAdvancedItemHandlerModifiable)handler;
            return advanced;
        }
        return new IAdvancedItemHandlerModifiable(){

            public int getSlots() {
                return handler.getSlots();
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return handler.getStackInSlot(slot);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return handler.insertItem(slot, stack, simulate);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return handler.extractItem(slot, amount, simulate);
            }

            public int getSlotLimit(int slot) {
                return handler.getSlotLimit(slot);
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return handler.isItemValid(slot, stack);
            }

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                handler.setStackInSlot(slot, stack);
            }
        };
    }
}

